package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes;

import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.io.FileInputStream;
import java.io.IOException;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteFichier;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Gnration de l'empreinte d'un fichier
 *
 */
public class GenererEmpreinteFichier{

	/**
	 * Le loggeur
	 */
	 private static Logger log = Logger.getLogger(GenererEmpreinteFichier.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param typeAlgo Type de l'algorithme
	 * @param fis Flux du fichier  hasher
	 * @return Rsultat de l'opration 
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long typeAlgo, FileInputStream fis) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
	
				if(fis != null) {
				
					ResultatEmpreinteFichier resultat = new ResultatEmpreinteFichier("Gnration de l'empreinte d'un fichier avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Initialisation (C_DigestInit))", "Gnration de l'empreinte d'un fichier avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Gnration (C_DigestUpdate))", "Gnration de l'empreinte d'un fichier avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Finalisation (C_DigestFinal))");
				
					CK_MECHANISM algo = new CK_MECHANISM();
					algo.mechanism=typeAlgo;
				
					byte[] empreinte = null;
					boolean erreurSurvenue = false;
					
					// Traitements  tester
					try {
	
						//# INIT #//
						librairie.C_DigestInit(idSession, algo);
						
					} catch (PKCS11Exception e) {
						
						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour(e.getErrorCode());
						erreurSurvenue = true;
						resultat.setCodeRetour2(TraitementsUtil.AUCUN_CODE_RETOUR);
						resultat.appendOperation2(" NON EXECUTEE!");
						resultat.setCodeRetour3(TraitementsUtil.AUCUN_CODE_RETOUR);
						resultat.appendOperation3(" NON EXECUTEE!");
						
					}
					
					try {
					
						//# GENERATION DU CONDENSAT PAR UPDATES #//
						if(!erreurSurvenue) {
						    int retourLecture = 0;
						    boolean eof = false;
						    int longeurBlocsLecture = 1024;
						    
						     while (!eof)
						     {
						    	 // Lecture par blocs
						    	 retourLecture = 0;
						         byte[] donneesACondenser = new byte[longeurBlocsLecture];
						         retourLecture = fis.read(donneesACondenser, 0, longeurBlocsLecture);
		
						         // Plus rien  lire
						         if (retourLecture == -1)
						             break;
						         librairie.C_DigestUpdate(idSession, donneesACondenser);
						     }
						}
						
					} catch (IOException e) {
						
						log.error("Probleme d'entree/sortie\n"+e.getMessage());
						erreurSurvenue = true;
						resultat.setCodeRetour3(TraitementsUtil.AUCUN_CODE_RETOUR);
						resultat.appendOperation3(" NON EXECUTEE!");
						
					} catch (PKCS11Exception e) {

						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour2(e.getErrorCode());
						erreurSurvenue = true;
						resultat.setCodeRetour3(TraitementsUtil.AUCUN_CODE_RETOUR);
						resultat.appendOperation3(" NON EXECUTEE!");
						
					}
					
					try {
						
						//# FINAL #//
						if(!erreurSurvenue) {
							
							empreinte = librairie.C_DigestFinal(idSession);
							if(empreinte != null)
								resultat.setEmpreinte(TraitementsUtil.getHexadecimal(empreinte,null));
							else {

								// Si l'empreinte est nulle on lve l'exception
								log.error("L'operation a retourne une empreinte nulle");
								throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_FICHIER, "L'opration a retourn une empreinte nulle");

							}
							
						}
					} catch (PKCS11Exception e) {
						
						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour3(e.getErrorCode());
						
					}
					
					return resultat;
						
				} else {
					
					// Si le fichier est illisible il est impossible de raliser l'opration
					log.error("Le fichier est illisible");
					throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_FICHIER, "Le fichier est illisible");				
					
				}
			
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_FICHIER, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_FICHIER, "Une erreur inattendue est survenue");
			
		}
		
	}
}
